/*=============================================================================
 MPP_MiniMap_KuroCustom.js 
----------------------------------------------------------------------------

/*:
 * @plugindesc ミニマップ くろあめ工房カスタム
 * @author くろあめ
 * @target MZ
 *
 * @help 木星ペンギンさんのミニマッププラグインの
 *  通行不可リージョン、通行可能リージョンの指定を
 *  地形タグでも指定できるようにします。
 *  
 *  指定した地形タグを持つマスは、実際の通行可能(不能)に関わらず
 *  ミニマップ上では通行可能(不能)のマスとして描画されます。
 *
 *  @param Wall Tag IDs
 *      @text 通行不可タグ
 *      @desc 通行不可として表示する地形タグの配列
 * (範囲指定可)
 *      @default 1
 *
 *  @param Floor Tag IDs
 *      @text 通行可能タグ
 *      @desc 通行可能として表示する地形タグの配列
 * (範囲指定可)
 *      @default 
 *
 */


(() => {
    'use strict';
    
    // Plugin Parameters
    const pluginNameOG = 'MPP_MiniMap';
    const parametersOG = PluginManager.parameters(pluginNameOG);

    const pluginName = 'MPP_MiniMap_KuroCustom';
    const parameters = PluginManager.parameters(pluginName);
    const convertToArray = (param) => {
        return param.split(',').reduce((r, item) => {
            const match = /(\d+)-(\d+)/.exec(item);
            if (match) {
                const start = Number(match[1]);
                const end = Number(match[2]);
                return r.concat([...Array(end + 1).keys()].slice(start));
            } else {
                return item ? r.concat(Number(item)) : r;
            }
        }, []);
    };
    const reviverParse = function(key, value) {
        try {
            return JSON.parse(value, reviverParse);
        } catch (e) {
            return value;
        }
    };
    const param_WallTagIDs = convertToArray(parameters['Wall Tag IDs']);
    const param_FloorTagIDs = convertToArray(parameters['Floor Tag IDs']);
    const param_WallRegionIDs = convertToArray(parametersOG['Wall Region IDs']);
    const param_FloorRegionIDs = convertToArray(parametersOG['Floor Region IDs']);
    
    MinimapImage.isForcedWall = function(x, y) {
        const regionId = $gameMap.regionId(x, y);
        const tagId = $gameMap.terrainTag(x, y);
        return (param_WallRegionIDs.includes(regionId) || param_WallTagIDs.includes(tagId));
    };
    
    MinimapImage.isForcedFloor = function(x, y) {
        const regionId = $gameMap.regionId(x, y);
        const tagId = $gameMap.terrainTag(x, y);
        return (param_FloorRegionIDs.includes(regionId) || param_FloorRegionIDs.includes(tagId));
    };

})();
